/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.platforms.core.registries.deferred.impl.custom;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistry;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import mod.chiselsandbits.platforms.core.registries.deferred.ICustomRegistrar;
import mod.chiselsandbits.platforms.core.registries.deferred.IRegistryObject;
import mod.chiselsandbits.platforms.core.registries.deferred.impl.custom.CustomRegistry;
import mod.chiselsandbits.platforms.core.registries.deferred.impl.custom.CustomRegistryObject;
import net.minecraft.class_2960;

public class CustomRegistrar<T extends IChiselsAndBitsRegistryEntry>
implements ICustomRegistrar<T> {
    private IChiselsAndBitsRegistry<T> registry = null;
    private final Collection<Supplier<T>> preBuildValueSuppliers = new ConcurrentLinkedDeque<Supplier<T>>();
    private final String owner;

    public CustomRegistrar(String owner) {
        this.owner = owner;
    }

    @Override
    public Supplier<IChiselsAndBitsRegistry<T>> makeRegistry(Supplier<IChiselsAndBitsRegistry.Builder<T>> registryBuilder) {
        if (this.registry == null) {
            this.registry = registryBuilder.get().build();
            if (!(this.registry instanceof CustomRegistry)) {
                throw new IllegalArgumentException("The builder does not produce a registry which is compatible with the Forge Platform runtime!");
            }
            this.preBuildValueSuppliers.forEach(s -> ((CustomRegistry)this.registry).register((IChiselsAndBitsRegistryEntry)s.get()));
        }
        return () -> this.registry;
    }

    @Override
    public <I extends T> IRegistryObject<I> register(String name, Supplier<? extends I> factory) {
        if (this.registry == null) {
            this.preBuildValueSuppliers.add(() -> {
                IChiselsAndBitsRegistryEntry entry = (IChiselsAndBitsRegistryEntry)factory.get();
                if (entry instanceof AbstractCustomRegistryEntry) {
                    ((AbstractCustomRegistryEntry)entry).setRegistryName(new class_2960(this.owner, name));
                } else if (entry.getRegistryName() == null) {
                    throw new IllegalStateException("Tried to create a registry entry which does not extend SimpleChiselsAndBitsRegistryEntry and also has no name set!");
                }
                return entry;
            });
            return new CustomRegistryObject(new class_2960(this.owner, name), () -> this.registry);
        }
        IChiselsAndBitsRegistryEntry entry = (IChiselsAndBitsRegistryEntry)factory.get();
        if (entry instanceof AbstractCustomRegistryEntry) {
            ((AbstractCustomRegistryEntry)entry).setRegistryName(new class_2960(this.owner, name));
        } else if (entry.getRegistryName() == null) {
            throw new IllegalStateException("Tried to create a registry entry which does not extend SimpleChiselsAndBitsRegistryEntry and also has no name set!");
        }
        ((CustomRegistry)this.registry).register(entry);
        return new CustomRegistryObject(new class_2960(this.owner, name), () -> this.registry);
    }
}

